/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class ScreenCapTool {
    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(() -> {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            MainFrame mainFrame = new MainFrame();
            mainFrame.setVisible(true);
        });
    }

    static String rectToString(Rectangle rectangle) {
        return rectangle.x + "," + rectangle.y + "," + rectangle.width + "," + rectangle.height;
    }

    static Rectangle parseRect(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).isEmpty()) {
            return null;
        }
        String[] stringArray = string.split(",");
        if (stringArray.length != 4) {
            return null;
        }
        try {
            int n = Integer.parseInt(stringArray[0].trim());
            int n2 = Integer.parseInt(stringArray[1].trim());
            int n3 = Integer.parseInt(stringArray[2].trim());
            int n4 = Integer.parseInt(stringArray[3].trim());
            if (n3 <= 0 || n4 <= 0) {
                return null;
            }
            return new Rectangle(n, n2, n3, n4);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static void ensureDir(File file) {
        if (file != null && !file.exists()) {
            file.mkdirs();
        }
    }

    static class MainFrame
    extends JFrame {
        private final JTextField urlField = new JTextField();
        private final JTextField regionField = new JTextField();
        private final JComboBox<String> templateCombo = new JComboBox();
        private final JLabel previewLabel = new JLabel("No capture yet", 0);
        private final JLabel statusLabel = new JLabel("Ready");
        private final JTextField outputField = new JTextField();
        private final JCheckBox autoCheck = new JCheckBox("Auto-capture");
        private final JSpinner autoEverySec = new JSpinner(new SpinnerNumberModel(10, 1, 3600, 1));
        private final JCheckBox fullScreenDefault = new JCheckBox("Full screen (all monitors)");
        private Rectangle currentRegion = null;
        private Timer autoTimer;
        private final File appDir;
        private final File templateStore;

        MainFrame() {
            super("Screen Cap ^_^* shot Tool _ v.1.0");
            this.setDefaultCloseOperation(3);
            this.setMinimumSize(new Dimension(920, 650));
            this.setLocationByPlatform(true);
            this.appDir = this.resolveAppDir();
            this.templateStore = new File(this.appDir, "templates.properties");
            JPanel jPanel = new JPanel(new BorderLayout(12, 12));
            jPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
            this.setContentPane(jPanel);
            JPanel jPanel2 = new JPanel(new GridBagLayout());
            jPanel.add((Component)jPanel2, "North");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 0.0;
            jPanel2.add((Component)new JLabel("URL"), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            jPanel2.add((Component)this.urlField, gridBagConstraints);
            JButton jButton = new JButton("Open");
            jButton.addActionListener(actionEvent -> this.openUrl());
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 0.0;
            jPanel2.add((Component)jButton, gridBagConstraints);
            JButton jButton2 = new JButton("Copy");
            jButton2.setToolTipText("Copy URL to clipboard");
            jButton2.addActionListener(actionEvent -> this.copyToClipboard(this.urlField.getText().trim()));
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 0;
            jPanel2.add((Component)jButton2, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 0.0;
            jPanel2.add((Component)new JLabel("Region"), gridBagConstraints);
            this.regionField.setEditable(false);
            this.regionField.setToolTipText("x,y,width,height");
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            jPanel2.add((Component)this.regionField, gridBagConstraints);
            JButton jButton3 = new JButton("Select area (F8)");
            jButton3.addActionListener(actionEvent -> this.selectArea());
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 0.0;
            jPanel2.add((Component)jButton3, gridBagConstraints);
            JButton jButton4 = new JButton("Capture (F9)");
            jButton4.addActionListener(actionEvent -> this.capture(false));
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 1;
            jPanel2.add((Component)jButton4, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.weightx = 0.0;
            jPanel2.add((Component)new JLabel("Templates"), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.weightx = 1.0;
            jPanel2.add(this.templateCombo, gridBagConstraints);
            JButton jButton5 = new JButton("Load");
            jButton5.addActionListener(actionEvent -> this.loadTemplate());
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.weightx = 0.0;
            jPanel2.add((Component)jButton5, gridBagConstraints);
            JButton jButton6 = new JButton("Save template (Ctrl+S)");
            jButton6.addActionListener(actionEvent -> this.saveTemplate());
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 2;
            jPanel2.add((Component)jButton6, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.weightx = 0.0;
            jPanel2.add((Component)new JLabel("Output"), gridBagConstraints);
            this.outputField.setEditable(false);
            this.outputField.setText(this.defaultOutputDir().getAbsolutePath());
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.weightx = 1.0;
            jPanel2.add((Component)this.outputField, gridBagConstraints);
            JButton jButton7 = new JButton("Choose\u2026");
            jButton7.addActionListener(actionEvent -> this.chooseOutputDir());
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.weightx = 0.0;
            jPanel2.add((Component)jButton7, gridBagConstraints);
            JButton jButton8 = new JButton("Open folder");
            jButton8.addActionListener(actionEvent -> this.openFolder(new File(this.outputField.getText())));
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 3;
            jPanel2.add((Component)jButton8, gridBagConstraints);
            JPanel jPanel3 = new JPanel(new FlowLayout(0, 10, 0));
            this.fullScreenDefault.setSelected(true);
            this.fullScreenDefault.addActionListener(actionEvent -> {
                if (this.fullScreenDefault.isSelected()) {
                    this.setRegion(ScreenUtil.getVirtualBounds());
                    this.setStatus("Region set to full screen (all monitors).");
                }
            });
            jPanel3.add(this.fullScreenDefault);
            jPanel3.add(this.autoCheck);
            jPanel3.add(new JLabel("every"));
            jPanel3.add(this.autoEverySec);
            jPanel3.add(new JLabel("sec"));
            JButton jButton9 = new JButton("Snap now");
            jButton9.addActionListener(actionEvent -> this.capture(false));
            jPanel3.add(jButton9);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.weightx = 1.0;
            jPanel2.add((Component)jPanel3, gridBagConstraints);
            gridBagConstraints.gridwidth = 1;
            this.autoCheck.addActionListener(actionEvent -> this.toggleAuto());
            this.previewLabel.setOpaque(true);
            this.previewLabel.setBackground(new Color(245, 245, 245));
            this.previewLabel.setBorder(BorderFactory.createLineBorder(new Color(210, 210, 210)));
            jPanel.add((Component)this.previewLabel, "Center");
            JPanel jPanel4 = new JPanel(new BorderLayout(8, 8));
            jPanel.add((Component)jPanel4, "South");
            JPanel jPanel5 = new JPanel(new FlowLayout(0, 8, 0));
            JButton jButton10 = new JButton("Delete template");
            jButton10.addActionListener(actionEvent -> this.deleteTemplate());
            jPanel5.add(jButton10);
            JButton jButton11 = new JButton("Clear region");
            jButton11.addActionListener(actionEvent -> {
                this.setRegion(null);
                this.fullScreenDefault.setSelected(false);
            });
            jPanel5.add(jButton11);
            JButton jButton12 = new JButton("Help");
            jButton12.addActionListener(actionEvent -> this.showHelpAnimated());
            jPanel5.add(jButton12);
            jPanel4.add((Component)jPanel5, "West");
            this.statusLabel.setBorder(new EmptyBorder(6, 6, 6, 6));
            jPanel4.add((Component)this.statusLabel, "Center");
            this.installShortcuts();
            this.ensureDir(this.appDir);
            this.refreshTemplates();
            this.setRegion(ScreenUtil.getVirtualBounds());
            this.setStatus("Default region: full screen (all monitors).");
        }

        private void installShortcuts() {
            JRootPane jRootPane = this.getRootPane();
            InputMap inputMap = jRootPane.getInputMap(2);
            ActionMap actionMap = jRootPane.getActionMap();
            inputMap.put(KeyStroke.getKeyStroke(119, 0), "select");
            actionMap.put("select", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.selectArea();
                }
            });
            inputMap.put(KeyStroke.getKeyStroke(120, 0), "capture");
            actionMap.put("capture", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.capture(false);
                }
            });
            inputMap.put(KeyStroke.getKeyStroke(83, 128), "saveTpl");
            actionMap.put("saveTpl", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.saveTemplate();
                }
            });
            inputMap.put(KeyStroke.getKeyStroke(127, 0), "delTpl");
            actionMap.put("delTpl", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.deleteTemplate();
                }
            });
        }

        private void setStatus(String string) {
            this.statusLabel.setText(string);
        }

        private void openUrl() {
            Object object = this.urlField.getText().trim();
            if (((String)object).isEmpty()) {
                JOptionPane.showMessageDialog(this, "Please enter a URL.", "Missing URL", 2);
                return;
            }
            if (!((String)object).matches("^[a-zA-Z][a-zA-Z0-9+.-]*://.*")) {
                object = "https://" + (String)object;
                this.urlField.setText((String)object);
            }
            try {
                Desktop.getDesktop().browse(new URI((String)object));
                this.setStatus("Opened in browser.");
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Could not open URL.\n" + exception.getMessage(), "Error", 0);
            }
        }

        private void copyToClipboard(String string) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string == null ? "" : string), null);
            this.setStatus("Copied to clipboard.");
        }

        private void setRegion(Rectangle rectangle) {
            this.currentRegion = rectangle;
            this.regionField.setText(rectangle == null ? "" : ScreenCapTool.rectToString(rectangle));
        }

        private void selectArea() {
            try {
                this.fullScreenDefault.setSelected(false);
                Rectangle rectangle = ScreenUtil.getVirtualBounds();
                RegionSelectorDialog regionSelectorDialog = new RegionSelectorDialog((Window)this, rectangle, this.currentRegion);
                Rectangle rectangle2 = regionSelectorDialog.pick();
                if (rectangle2 != null && rectangle2.width > 0 && rectangle2.height > 0) {
                    this.setRegion(rectangle2);
                    this.setStatus("Region selected: " + ScreenCapTool.rectToString(rectangle2));
                } else {
                    this.setStatus("Selection cancelled.");
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Could not select area.\n" + exception.getMessage(), "Error", 0);
            }
        }

        private void refreshTemplates() {
            Properties properties = this.loadTemplates();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Object object : properties.keySet()) {
                arrayList.add(String.valueOf(object));
            }
            arrayList.sort(String.CASE_INSENSITIVE_ORDER);
            this.templateCombo.removeAllItems();
            for (String string : arrayList) {
                this.templateCombo.addItem(string);
            }
        }

        private void loadTemplate() {
            String string = (String)this.templateCombo.getSelectedItem();
            if (string == null || string.isBlank()) {
                return;
            }
            Properties properties = this.loadTemplates();
            Rectangle rectangle = ScreenCapTool.parseRect(properties.getProperty(string));
            if (rectangle == null) {
                JOptionPane.showMessageDialog(this, "Template is invalid.", "Error", 0);
                return;
            }
            this.setRegion(rectangle);
            this.fullScreenDefault.setSelected(false);
            this.setStatus("Loaded template: " + string);
        }

        private void saveTemplate() {
            if (this.currentRegion == null) {
                JOptionPane.showMessageDialog(this, "Select a region first (F8).", "No region", 2);
                return;
            }
            String string = JOptionPane.showInputDialog(this, "Template name:", "Save template", 3);
            if (string == null) {
                return;
            }
            if ((string = string.trim()).isEmpty()) {
                JOptionPane.showMessageDialog(this, "Template name cannot be empty.", "Invalid name", 2);
                return;
            }
            Properties properties = this.loadTemplates();
            properties.setProperty(string, ScreenCapTool.rectToString(this.currentRegion));
            this.storeTemplates(properties);
            this.refreshTemplates();
            this.templateCombo.setSelectedItem(string);
            this.setStatus("Template saved: " + string);
        }

        private void deleteTemplate() {
            String string = (String)this.templateCombo.getSelectedItem();
            if (string == null || string.isBlank()) {
                JOptionPane.showMessageDialog(this, "No template selected.", "Delete template", 2);
                return;
            }
            int n = JOptionPane.showConfirmDialog(this, "Delete template \"" + string + "\"?", "Confirm", 0);
            if (n != 0) {
                return;
            }
            Properties properties = this.loadTemplates();
            properties.remove(string);
            this.storeTemplates(properties);
            this.refreshTemplates();
            this.setStatus("Template deleted.");
        }

        private void chooseOutputDir() {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setDialogTitle("Choose output folder");
            jFileChooser.setCurrentDirectory(new File(this.outputField.getText()));
            if (jFileChooser.showOpenDialog(this) == 0) {
                File file = jFileChooser.getSelectedFile();
                this.outputField.setText(file.getAbsolutePath());
                this.setStatus("Output folder set.");
            }
        }

        private void openFolder(File file) {
            try {
                this.ensureDir(file);
                Desktop.getDesktop().open(file);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Could not open folder.\n" + exception.getMessage(), "Error", 0);
            }
        }

        private void toggleAuto() {
            if (this.autoCheck.isSelected()) {
                if (this.currentRegion == null) {
                    this.autoCheck.setSelected(false);
                    JOptionPane.showMessageDialog(this, "No region selected.", "No region", 2);
                    return;
                }
                int n = (Integer)this.autoEverySec.getValue();
                this.autoTimer = new Timer(n * 1000, actionEvent -> this.capture(true));
                this.autoTimer.setRepeats(true);
                this.autoTimer.start();
                this.setStatus("Auto-capture enabled (" + n + "s).");
            } else {
                if (this.autoTimer != null) {
                    this.autoTimer.stop();
                }
                this.autoTimer = null;
                this.setStatus("Auto-capture disabled.");
            }
        }

        private void capture(boolean bl) {
            if (this.currentRegion == null) {
                if (!bl) {
                    JOptionPane.showMessageDialog(this, "No region selected.", "No region", 2);
                }
                return;
            }
            try {
                File file = new File(this.outputField.getText());
                this.ensureDir(file);
                String string = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
                File file2 = new File(file, "capture_" + string + ".png");
                Robot robot = new Robot();
                BufferedImage bufferedImage = robot.createScreenCapture(this.currentRegion);
                ImageIO.write((RenderedImage)bufferedImage, "png", file2);
                this.updatePreview(bufferedImage, file2.getName());
                this.setStatus("Saved: " + file2.getAbsolutePath());
            }
            catch (SecurityException securityException) {
                JOptionPane.showMessageDialog(this, "Screen capture permission denied by the OS.\n\n" + securityException.getMessage(), "Permission error", 0);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Capture failed.\n" + exception.getMessage(), "Error", 0);
            }
        }

        private void updatePreview(BufferedImage bufferedImage, String string) {
            if (bufferedImage == null) {
                return;
            }
            int n = Math.max(300, this.previewLabel.getWidth());
            int n2 = Math.max(200, this.previewLabel.getHeight());
            Image image = bufferedImage.getScaledInstance(n, n2, 4);
            this.previewLabel.setText("");
            this.previewLabel.setIcon(new ImageIcon(image));
            this.previewLabel.setToolTipText(string);
        }

        private void showHelpAnimated() {
            String string = "Workflow:\n1) Open the URL in your browser and log in.\n2) (Optional) Press F8 and drag to select a region.\n3) Press F9 to capture to PNG.\n4) Ctrl+S saves the region as a named template.\n\nDefault on startup:\n- Full screen (all monitors) is active.\n\nSelection overlay:\n- You can see the page behind the overlay.\n- Drag with the left mouse button.\n- Release to confirm.\n- ESC cancels.\n\nHotkeys:\n- F8: Select area\n- F9: Capture\n- Ctrl+S: Save template\n- Delete: Delete selected template\n";
            String string2 = "\n\nScreenCap ^_^* is a free tool that anyone can use to capture screenshots quickly and easily. It\u2019s made for everyone who wants a simple, reliable way to take screenshots\u2014no subscriptions, no paywalls, no unnecessary complexity. Just open it, choose what you want to capture (full page, a selected area, or a saved template), and create clean screenshots whenever you need them.\n\nWebsite: https://lukasz-wrobel.com/screencap-shot-tool\n\nScreenCap is free. If it saves you time, please support its development with a donation. Thank you!\nDonate: https://www.paypal.com/donate/?hosted_button_id=5WS63BVC8KANQ";
            SpaceHelpDialog spaceHelpDialog = new SpaceHelpDialog((Window)this, string + string2);
            spaceHelpDialog.setVisible(true);
        }

        private File resolveAppDir() {
            String string = System.getenv("APPDATA");
            if (string != null && !string.isBlank()) {
                return new File(string, "ScreenCapTool");
            }
            return new File(System.getProperty("user.home"), ".screencap-tool");
        }

        private File defaultOutputDir() {
            String string = System.getProperty("user.home");
            File file = new File(string, "Pictures");
            File file2 = new File(string, "Bilder");
            File file3 = file.exists() ? file : (file2.exists() ? file2 : new File(string));
            return new File(file3, "ScreenCaptures");
        }

        private void ensureDir(File file) {
            if (file != null && !file.exists()) {
                file.mkdirs();
            }
        }

        private Properties loadTemplates() {
            Properties properties = new Properties();
            if (this.templateStore.exists()) {
                try (FileInputStream fileInputStream = new FileInputStream(this.templateStore);){
                    properties.load(new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return properties;
        }

        private void storeTemplates(Properties properties) {
            this.ensureDir(this.appDir);
            try (FileOutputStream fileOutputStream = new FileOutputStream(this.templateStore);){
                properties.store(new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8), "Region templates: name=x,y,width,height");
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Could not save templates.\n" + exception.getMessage(), "Error", 0);
            }
        }
    }

    static class ScreenUtil {
        ScreenUtil() {
        }

        static Rectangle getVirtualBounds() {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
            Rectangle rectangle = null;
            for (GraphicsDevice graphicsDevice : graphicsDeviceArray) {
                Rectangle rectangle2 = graphicsDevice.getDefaultConfiguration().getBounds();
                rectangle = rectangle == null ? new Rectangle(rectangle2) : rectangle.union(rectangle2);
            }
            if (rectangle == null) {
                rectangle = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
            }
            return rectangle;
        }
    }

    static class SpacePanel
    extends JPanel {
        private final Random rnd = new Random();
        private final Star[] stars = new Star[220];
        private Timer timer;
        private float phase = 0.0f;
        private final JEditorPane html;
        private Dimension htmlPref = new Dimension(520, 600);
        private float textY;
        private boolean finished = false;

        SpacePanel(String string) {
            this.setOpaque(true);
            this.setBackground(Color.BLACK);
            this.setFocusable(true);
            this.setLayout(null);
            for (int i = 0; i < this.stars.length; ++i) {
                this.stars[i] = new Star();
            }
            final JButton jButton = new JButton("Close");
            jButton.addActionListener(actionEvent -> SwingUtilities.getWindowAncestor(this).dispose());
            this.add(jButton);
            this.html = new JEditorPane();
            this.html.setContentType("text/html");
            this.html.setEditable(false);
            this.html.setOpaque(false);
            this.html.setBorder(null);
            this.html.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            String string2 = SpacePanel.escapeHtml(string);
            string2 = string2.replace("\r\n", "\n");
            String string3 = "https://lukasz-wrobel.com/screencap-shot-tool";
            string2 = string2.replace(string3, "<a href=\"" + string3 + "\">" + string3 + "</a>");
            String string4 = "https://www.paypal.com/donate/?hosted_button_id=5WS63BVC8KANQ";
            string2 = string2.replace("Donate: " + string4, "Donate: <a class=\"donateBtn\" href=\"" + string4 + "\">Donate</a>");
            string2 = string2.replace("\n", "<br>");
            String string5 = "<html><head><style>body{color:#ffffff;font-family:Segoe UI,Arial,sans-serif;font-size:15px;line-height:1.35;margin:0;padding:0;}a{color:#9fd4ff;text-decoration:underline;}.donateBtn{display:inline-block;margin-top:6px;padding:10px 14px;border-radius:10px;background:rgba(160,210,255,0.18);border:1px solid rgba(160,210,255,0.55);color:#ffffff;text-decoration:none;font-weight:700;}.donateBtn:hover{background:rgba(160,210,255,0.28);}</style></head><body>" + string2 + "</body></html>";
            this.html.setText(string5);
            this.html.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                    if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        try {
                            Desktop.getDesktop().browse(hyperlinkEvent.getURL().toURI());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
            this.add(this.html);
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    int n = this.getWidth();
                    int n2 = this.getHeight();
                    jButton.setBounds(n - 92, n2 - 44, 80, 28);
                    int n3 = Math.max(300, n - 40);
                    html.setSize(n3, 10);
                    htmlPref = html.getPreferredSize();
                    html.setSize(n3, htmlPref.height);
                    if (!finished) {
                        textY = Math.min(textY, (float)n2 + 30.0f);
                    }
                    this.positionHtml();
                }
            });
            jButton.setBounds(468, 336, 80, 28);
            this.html.setBounds(20, 9999, 520, 10);
            this.textY = 1000.0f;
        }

        void start() {
            int n = Math.max(1, this.getWidth());
            int n2 = Math.max(1, this.getHeight());
            for (Star star : this.stars) {
                star.reset(n, n2, this.rnd);
            }
            int n3 = Math.max(300, n - 40);
            this.html.setSize(n3, 10);
            this.htmlPref = this.html.getPreferredSize();
            this.html.setSize(n3, this.htmlPref.height);
            this.textY = (float)n2 + 30.0f;
            this.finished = false;
            if (this.timer != null) {
                this.timer.stop();
            }
            this.timer = new Timer(16, actionEvent -> this.tick());
            this.timer.start();
            this.positionHtml();
        }

        void stop() {
            if (this.timer != null) {
                this.timer.stop();
            }
            this.timer = null;
        }

        private void positionHtml() {
            int n = this.getWidth();
            int n2 = Math.max(300, n - 40);
            int n3 = 20;
            int n4 = (int)(Math.sin(this.phase) * 10.0);
            this.html.setBounds(n3 + n4, (int)this.textY, n2, this.htmlPref.height);
            this.html.repaint();
        }

        private void tick() {
            int n = this.getWidth();
            int n2 = this.getHeight();
            float f = (float)n / 2.0f;
            float f2 = (float)n2 / 2.0f;
            for (Star star : this.stars) {
                float f3 = star.x - f;
                float f4 = star.y - f2;
                float f5 = 0.0025f;
                star.vx += f3 * f5;
                star.vy += f4 * f5;
                star.x += star.vx;
                star.y += star.vy;
                star.size += 0.015f;
                star.alpha = Math.min(1.0f, star.alpha + 0.004f);
                if (!(star.x < -50.0f || star.x > (float)(n + 50) || star.y < -50.0f) && !(star.y > (float)(n2 + 50))) continue;
                star.reset(n, n2, this.rnd);
            }
            if (!this.finished) {
                this.textY -= 0.55f;
                float f6 = this.textY + (float)this.htmlPref.height;
                float f7 = (float)n2 - 62.0f;
                if (f6 <= f7) {
                    float f8 = f7 - f6;
                    this.textY += f8;
                    this.finished = true;
                }
            }
            this.phase += 0.03f;
            this.positionHtml();
            this.repaint();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            try {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int n = this.getWidth();
                int n2 = this.getHeight();
                GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, new Color(0, 0, 0), 0.0f, n2, new Color(10, 10, 18));
                graphics2D.setPaint(gradientPaint);
                graphics2D.fillRect(0, 0, n, n2);
                for (Star star : this.stars) {
                    int n3 = (int)star.x;
                    int n4 = (int)star.y;
                    int n5 = (int)Math.max(1.0f, star.size);
                    int n6 = (int)(star.x - star.vx * 2.2f);
                    int n7 = (int)(star.y - star.vy * 2.2f);
                    graphics2D.setComposite(AlphaComposite.SrcOver.derive(Math.min(1.0f, star.alpha)));
                    graphics2D.setColor(Color.WHITE);
                    graphics2D.drawLine(n6, n7, n3, n4);
                    graphics2D.fillOval(n3 - n5 / 2, n4 - n5 / 2, n5, n5);
                }
                graphics2D.setComposite(AlphaComposite.SrcOver);
                graphics2D.setFont(this.getFont().deriveFont(0, 12.0f));
                graphics2D.setColor(new Color(255, 255, 255, 160));
                graphics2D.drawString("Screen Cap ^_^* shot Tool _ v.1.0  \u2022  Help", 12, 18);
            }
            finally {
                graphics2D.dispose();
            }
        }

        private static String escapeHtml(String string) {
            if (string == null) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder(string.length() + 64);
            block6: for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '&': {
                        stringBuilder.append("&amp;");
                        continue block6;
                    }
                    case '<': {
                        stringBuilder.append("&lt;");
                        continue block6;
                    }
                    case '>': {
                        stringBuilder.append("&gt;");
                        continue block6;
                    }
                    case '\"': {
                        stringBuilder.append("&quot;");
                        continue block6;
                    }
                    default: {
                        stringBuilder.append(c);
                    }
                }
            }
            return stringBuilder.toString();
        }

        private static class Star {
            float x;
            float y;
            float vx;
            float vy;
            float size;
            float alpha;

            private Star() {
            }

            void reset(int n, int n2, Random random) {
                float f = (float)n / 2.0f;
                float f2 = (float)n2 / 2.0f;
                this.x = f + (random.nextFloat() - 0.5f) * ((float)n * 0.15f);
                this.y = f2 + (random.nextFloat() - 0.5f) * ((float)n2 * 0.15f);
                float f3 = (float)((double)random.nextFloat() * Math.PI * 2.0);
                float f4 = 0.6f + random.nextFloat() * 2.8f;
                this.vx = (float)Math.cos(f3) * f4;
                this.vy = (float)Math.sin(f3) * f4;
                this.size = 1.0f + random.nextFloat() * 2.0f;
                this.alpha = 0.35f + random.nextFloat() * 0.65f;
            }
        }
    }

    static class SpaceHelpDialog
    extends JDialog {
        SpaceHelpDialog(Window window, String string) {
            super(window, "Help", Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(2);
            this.setResizable(false);
            final SpacePanel spacePanel = new SpacePanel(string);
            this.setContentPane(spacePanel);
            this.setSize(new Dimension(560, 380));
            this.setLocationRelativeTo(window);
            InputMap inputMap = spacePanel.getInputMap(2);
            ActionMap actionMap = spacePanel.getActionMap();
            inputMap.put(KeyStroke.getKeyStroke(27, 0), "close");
            actionMap.put("close", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.dispose();
                }
            });
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent windowEvent) {
                    spacePanel.start();
                }

                @Override
                public void windowClosed(WindowEvent windowEvent) {
                    spacePanel.stop();
                }
            });
        }
    }

    static class SelectorPanel
    extends JComponent {
        private final Rectangle unionBounds;
        private Rectangle selection;
        private Point start;
        private Point cur;
        private ConfirmCallback cb;

        SelectorPanel(Rectangle rectangle, Rectangle rectangle2) {
            this.unionBounds = rectangle;
            this.selection = rectangle2 == null ? null : new Rectangle(rectangle2);
            this.setCursor(Cursor.getPredefinedCursor(1));
            this.setFocusable(true);
            this.setOpaque(false);
            MouseAdapter mouseAdapter = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    start = mouseEvent.getPoint();
                    cur = mouseEvent.getPoint();
                    this.updateSelection();
                    this.repaint();
                }

                @Override
                public void mouseDragged(MouseEvent mouseEvent) {
                    cur = mouseEvent.getPoint();
                    this.updateSelection();
                    this.repaint();
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    cur = mouseEvent.getPoint();
                    this.updateSelection();
                    this.repaint();
                    if (cb != null) {
                        cb.confirm(selection);
                    }
                }
            };
            this.addMouseListener(mouseAdapter);
            this.addMouseMotionListener(mouseAdapter);
        }

        void setOnConfirm(ConfirmCallback confirmCallback) {
            this.cb = confirmCallback;
        }

        private void updateSelection() {
            if (this.start == null || this.cur == null) {
                return;
            }
            int n = Math.min(this.start.x, this.cur.x);
            int n2 = Math.min(this.start.y, this.cur.y);
            int n3 = Math.max(this.start.x, this.cur.x);
            int n4 = Math.max(this.start.y, this.cur.y);
            int n5 = this.unionBounds.x + n;
            int n6 = this.unionBounds.y + n2;
            int n7 = Math.max(1, n3 - n);
            int n8 = Math.max(1, n4 - n2);
            this.selection = new Rectangle(n5, n6, n7, n8);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            try {
                graphics2D.setComposite(AlphaComposite.Clear);
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                graphics2D.setComposite(AlphaComposite.SrcOver.derive(0.28f));
                graphics2D.setColor(Color.BLACK);
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                graphics2D.setComposite(AlphaComposite.SrcOver);
                String string = "Drag to select area. Release to confirm. ESC cancels.";
                graphics2D.setFont(graphics2D.getFont().deriveFont(0, 16.0f));
                FontMetrics fontMetrics = graphics2D.getFontMetrics();
                int n = fontMetrics.stringWidth(string) + 24;
                int n2 = fontMetrics.getHeight() + 16;
                int n3 = (this.getWidth() - n) / 2;
                int n4 = 18;
                graphics2D.setColor(new Color(0, 0, 0, 200));
                graphics2D.fillRoundRect(n3, n4, n, n2, 14, 14);
                graphics2D.setColor(Color.WHITE);
                graphics2D.drawString(string, n3 + 12, n4 + n2 - 10);
                if (this.selection != null && this.selection.width > 0 && this.selection.height > 0) {
                    Rectangle rectangle = new Rectangle(this.selection.x - this.unionBounds.x, this.selection.y - this.unionBounds.y, this.selection.width, this.selection.height);
                    graphics2D.setComposite(AlphaComposite.SrcOver.derive(0.14f));
                    graphics2D.setColor(Color.WHITE);
                    graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    graphics2D.setComposite(AlphaComposite.SrcOver);
                    graphics2D.setStroke(new BasicStroke(2.0f));
                    graphics2D.setColor(new Color(255, 80, 80, 235));
                    graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    String string2 = "x=" + this.selection.x + " y=" + this.selection.y + " w=" + this.selection.width + " h=" + this.selection.height;
                    graphics2D.setFont(graphics2D.getFont().deriveFont(1, 14.0f));
                    FontMetrics fontMetrics2 = graphics2D.getFontMetrics();
                    int n5 = 8;
                    int n6 = fontMetrics2.stringWidth(string2) + n5 * 2;
                    int n7 = fontMetrics2.getHeight() + n5;
                    int n8 = Math.max(10, rectangle.x);
                    int n9 = Math.max(60, rectangle.y);
                    graphics2D.setColor(new Color(0, 0, 0, 200));
                    graphics2D.fillRoundRect(n8, n9 - n7, n6, n7, 10, 10);
                    graphics2D.setColor(Color.WHITE);
                    graphics2D.drawString(string2, n8 + n5, n9 - n5);
                }
            }
            finally {
                graphics2D.dispose();
            }
        }

        static interface ConfirmCallback {
            public void confirm(Rectangle var1);
        }
    }

    static class RegionSelectorDialog
    extends JDialog {
        private Rectangle selected = null;

        RegionSelectorDialog(Window window, Rectangle rectangle2, Rectangle rectangle3) {
            super(window, Dialog.ModalityType.APPLICATION_MODAL);
            this.setUndecorated(true);
            this.setAlwaysOnTop(true);
            this.setBounds(rectangle2);
            this.setBackground(new Color(0, 0, 0, 0));
            final SelectorPanel selectorPanel = new SelectorPanel(rectangle2, rectangle3);
            this.setContentPane(selectorPanel);
            InputMap inputMap = selectorPanel.getInputMap(2);
            ActionMap actionMap = selectorPanel.getActionMap();
            inputMap.put(KeyStroke.getKeyStroke(27, 0), "cancel");
            actionMap.put("cancel", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    selected = null;
                    this.dispose();
                }
            });
            selectorPanel.setOnConfirm(rectangle -> {
                this.selected = rectangle;
                this.dispose();
            });
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent windowEvent) {
                    selectorPanel.requestFocusInWindow();
                }
            });
        }

        Rectangle pick() {
            this.setVisible(true);
            return this.selected;
        }
    }
}

