#!/usr/bin/env bash
set -euo pipefail
cd "$(dirname "$0")"

# Build a Linux app-image folder with bundled Java runtime.
# Requirements:
# - Linux + JDK 17+ installed (jpackage available)
# - No internet required

NAME="ScreenCapShotTool"
VERSION="1.0"
DEST="$(pwd)/dist"

rm -rf "$DEST"
mkdir -p "$DEST"

jpackage   --type app-image   --name "$NAME"   --app-version "$VERSION"   --dest "$DEST"   --input "../common"   --main-jar "ScreenCapTool.jar"

echo
echo "Done. Output:"
echo "$DEST/$NAME/bin/$NAME"
