#!/bin/bash
set -euo pipefail
cd "$(dirname "$0")"

# Build a macOS .app (app-image) with bundled Java runtime.
# Requirements:
# - macOS + JDK 17+ installed (jpackage available)
# - No internet required

NAME="ScreenCapShotTool"
VERSION="1.0"
DEST="$(pwd)/dist"

rm -rf "$DEST"
mkdir -p "$DEST"

jpackage   --type app-image   --name "$NAME"   --app-version "$VERSION"   --dest "$DEST"   --input "../common"   --main-jar "ScreenCapTool.jar"

echo
echo "Done. Output:"
echo "$DEST/$NAME.app"
